/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface MultiConsumer<T>
extends Consumer<T> {
    default public void acceptAll(Iterable<T> iterable) {
        for (T t : iterable) {
            this.accept(t);
        }
    }

    default public void acceptAll(Iterator<T> iterator) {
        while (iterator.hasNext()) {
            this.accept(iterator.next());
        }
    }

    default public T drainUntil(Iterator<T> iterator, Predicate<T> predicate) {
        while (iterator.hasNext()) {
            T next = iterator.next();
            if (predicate.test(next)) {
                return next;
            }
            this.accept(next);
        }
        return null;
    }

    @Override
    @NotNull
    default public MultiConsumer<T> andThen(@NotNull Consumer<? super T> after) {
        Objects.requireNonNull(after);
        return t -> {
            this.accept(t);
            after.accept(t);
        };
    }
}

